#!/bin/sh

echo "Changing executable permissions.."
chmod 755 ./VSG || exit
chmod 755 ./bin/VSG || exit

echo "Configuring libraries.."
if [ ! -d "./lib" ]; then echo "Error: ./lib directory not found" && exit; fi
ldconfig -n ./lib

echo "Changing device permissions.."
sudo cp ./sh.rules /etc/udev/rules.d/ || exit

FILE=/etc/udev/rules.d/sh.rules
if test -f "$FILE"; then
    echo "\nInstallation successful\n\nRun VSG software in terminal with ./VSG\nor in Files by double-clicking 'VSG'\n"
else
    echo "\nUnable to change device permissions. Please copy sh.rules to /etc/udev/rules.d.\n"
fi
